<?php
include "../config/koneksi.php";
require_once __DIR__ . "/../vendor/fpdf186/fpdf.php";

$start = $_GET['start'] ?? '';
$end   = $_GET['end'] ?? '';

$pdf = new FPDF();
$pdf->AddPage();

// HEADER
$pdf->SetFont('Arial','B',14);
$pdf->Cell(0,10,'LAPORAN PEMESANAN TIKET',0,1,'C');
$pdf->Ln(3);

$pdf->SetFont('Arial','',10);
if ($start && $end) {
    $pdf->Cell(0,8,"Periode: $start s/d $end",0,1,'C');
}
$pdf->Ln(5);

// TABLE HEADER
$pdf->SetFont('Arial','B',10);
$pdf->Cell(40,8,'Nama User',1);
$pdf->Cell(50,8,'Event',1);
$pdf->Cell(25,8,'Jumlah',1);
$pdf->Cell(35,8,'Total (Rp)',1);
$pdf->Ln();

// DATA
$pdf->SetFont('Arial','',10);

$query = "
SELECT users.nama, events.nama_event, orders.jumlah, orders.total
FROM orders
JOIN users ON orders.user_id = users.id
JOIN events ON orders.event_id = events.id
";

if ($start && $end) {
    $query .= " WHERE DATE(orders.id) BETWEEN '$start' AND '$end'";
}

$data = mysqli_query($koneksi, $query);
$grandTotal = 0;

while($d = mysqli_fetch_assoc($data)) {
    $pdf->Cell(40,8,$d['nama'],1);
    $pdf->Cell(50,8,$d['nama_event'],1);
    $pdf->Cell(25,8,$d['jumlah'],1,0,'C');
    $pdf->Cell(35,8,number_format($d['total']),1,1,'R');
    $grandTotal += $d['total'];
}

// TOTAL
$pdf->SetFont('Arial','B',10);
$pdf->Cell(115,8,'TOTAL PENDAPATAN',1);
$pdf->Cell(35,8,'Rp '.number_format($grandTotal),1,1,'R');

$pdf->Output();
?>