<?php
session_start();
include "../config/koneksi.php";
include "../layout/header.php";

$q = mysqli_query($koneksi,"
    SELECT orders.*, users.nama, events.nama_event
    FROM orders
    JOIN users ON orders.user_id = users.id
    JOIN events ON orders.event_id = events.id
    ORDER BY orders.id DESC
");
?>

<h4>Data Pesanan</h4>

<table class="table table-bordered">
<tr>
    <th>Invoice</th>
    <th>User</th>
    <th>Event</th>
    <th>Total</th>
    <th>Bukti</th>
    <th>Status</th>
    <th>Aksi</th>
</tr>

<?php while($o = mysqli_fetch_assoc($q)): ?>
<tr>
    <td><?= $o['invoice']; ?></td>
    <td><?= $o['nama']; ?></td>
    <td><?= $o['nama_event']; ?></td>
    <td>Rp <?= number_format($o['total']); ?></td>
    <td>
        <?php if($o['bukti_bayar']): ?>
        <a href="../uploads/<?= $o['bukti_bayar']; ?>" target="_blank">Lihat</a>
        <?php endif; ?>
    </td>
    <td><?= $o['status']; ?></td>
    <td>
        <?php if($o['status']=='pending'): ?>
       <a href="validasi.php?id=<?= $o['id']; ?>" 
   class="btn btn-success btn-sm">
   Verifikasi
</a>

        <?php endif; ?>
    </td>
</tr>
<?php endwhile; ?>
</table>

<?php include "../layout/footer.php"; ?>
