<?php
ob_start(); // ⬅️ WAJIB, cegah output sebelum PDF
session_start();
include "../config/koneksi.php";
require "../vendor/fpdf186/fpdf.php";

// proteksi user
if (!isset($_SESSION['user'])) {
    die("Akses ditolak");
}

// validasi parameter
if (!isset($_GET['kode']) || $_GET['kode'] == '') {
    die("Kode tiket tidak valid");
}

$kode = mysqli_real_escape_string($koneksi, $_GET['kode']);

$q = mysqli_query($koneksi,"
    SELECT 
        orders.kode_tiket,
        orders.status,
        users.nama,
        events.nama_event,
        events.tanggal
    FROM orders
    JOIN users ON orders.user_id = users.id
    JOIN events ON orders.event_id = events.id
    WHERE orders.kode_tiket = '$kode'
      AND orders.status = 'paid'
");

$data = mysqli_fetch_assoc($q);

// kalau tiket belum dibayar / tidak ada
if (!$data) {
    die("Tiket belum dibayar atau tidak ditemukan");
}

// =====================
// GENERATE PDF
// =====================
$pdf = new FPDF();
$pdf->AddPage();
$pdf->SetFont('Arial','B',16);
$pdf->Cell(0,10,'E-TIKET ACARA',0,1,'C');
$pdf->Ln(5);

$pdf->SetFont('Arial','',12);
$pdf->Cell(0,8,'Nama Pemesan : '.$data['nama'],0,1);
$pdf->Cell(0,8,'Event        : '.$data['nama_event'],0,1);
$pdf->Cell(0,8,'Tanggal      : '.$data['tanggal'],0,1);
$pdf->Cell(0,8,'Kode Tiket   : '.$data['kode_tiket'],0,1);
$pdf->Cell(0,8,'Status       : '.strtoupper($data['status']),0,1);

$pdf->Ln(10);
$pdf->SetFont('Arial','I',10);
$pdf->Cell(0,8,'Tunjukkan tiket ini saat masuk acara',0,1,'C');

ob_end_clean(); // ⬅️ BERSIHIN OUTPUT
$pdf->Output("I","Tiket_".$data['kode_tiket'].".pdf");
exit;
?>